/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.generic.Interface;

import com.xiaoyue.tinkers_ingenuity.content.library.context.ArmorAttackContext;
import java.util.Collection;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public interface ArmorCombatHook {
    public static final ArmorCombatHook EMPTY = new ArmorCombatHook(){};

    default public void onHurtTarget(IToolStackView armor, LivingHurtEvent event, ArmorAttackContext context, int level) {
    }

    default public void onTakeHurt(IToolStackView armor, LivingHurtEvent event, ArmorAttackContext context, int level) {
    }

    default public void onTakeDamage(IToolStackView armor, LivingDamageEvent event, ArmorAttackContext context, int level) {
    }

    default public void onTakeHeal(IToolStackView armor, LivingHealEvent event, LivingEntity entity, int level) {
    }

    public record AllMerger(Collection<ArmorCombatHook> modules) implements ArmorCombatHook
    {
        @Override
        public void onHurtTarget(IToolStackView armor, LivingHurtEvent event, ArmorAttackContext context, int level) {
            for (ArmorCombatHook module : this.modules) {
                module.onHurtTarget(armor, event, context, level);
            }
        }

        @Override
        public void onTakeHurt(IToolStackView armor, LivingHurtEvent event, ArmorAttackContext context, int level) {
            for (ArmorCombatHook module : this.modules) {
                module.onTakeHurt(armor, event, context, level);
            }
        }

        @Override
        public void onTakeDamage(IToolStackView armor, LivingDamageEvent event, ArmorAttackContext context, int level) {
            for (ArmorCombatHook module : this.modules) {
                module.onTakeDamage(armor, event, context, level);
            }
        }

        @Override
        public void onTakeHeal(IToolStackView armor, LivingHealEvent event, LivingEntity entity, int level) {
            for (ArmorCombatHook module : this.modules) {
                module.onTakeHeal(armor, event, entity, level);
            }
        }
    }
}

